<?php

namespace App\Listeners;

use App\CouponTemplate;
use App\Events\CouponPaid;
use App\Services\UsersGiftService;

class UsersGiftCreate
{
    /**
     * Handle the event.
     *
     * @param  CouponPaid  $event
     * @return void
     */
    public function handle(CouponPaid $event)
    {
        $coupon = $event->coupon;

        if (CouponTemplate::TYPE_GIFT === $coupon->type_provision) {
            (new UsersGiftService())->create($coupon->provision_gift_id, $coupon->agent_user_id, $coupon->id);
        }

        if (CouponTemplate::TYPE_GIFT === $coupon->type_discount) {
            (new UsersGiftService())->create($coupon->discount_gift_id, $coupon->consumer_user_id, $coupon->id);
        }
    }
}
