<?php

namespace App\Listeners;


use App\Events\CouponFinishedClientTransactions;
use App\User;

class ReferralGotPaid
{
    /**
     * Handle the event.
     *
     * @param  CouponFinishedClientTransactions  $event
     * @return void
     */
    public function handle(CouponFinishedClientTransactions $event)
    {
        $coupon = $event->coupon;

        $consumer = User::find($coupon->consumer_user_id);
        if ($consumer->referred_by) {
            $consumer->referral_status = User::REFERRAL_STATUS_PAID;
            $consumer->save();
        }
    }
}