<?php

namespace App\Listeners;


use App\Services\DeviceService;
use App\Services\TFAService;
use Illuminate\Auth\Events\Login;

class PreventUntrustedDevice
{
    /**
     * Handle the event.
     *
     * @param Login $event
     */
    public function handle(Login $event)
    {
        $user = $event->user;
        $tfaService = new TFAService($user);
        $deviceService = new DeviceService();
        $currentDevice = $deviceService->current($user);

        if ( $tfaService->hasGoogleTFA() ) {
            $deviceService->untrust($user);
        } else if ( null !== $currentDevice && !$currentDevice->isTrusted() ) {
            $tfaService->generateSimpleToken();
        }
    }
}