<?php

namespace App\Listeners;

use App\Events\EmailChanged;
use App\Services\VerificationService;

class EmailSendValidationToken
{
    /**
     * Handle the event.
     *
     * @param  EmailChanged  $event
     * @return void
     */
    public function handle(EmailChanged $event)
    {
        $user = $event->user;

        // if user changed his email address
        if ( $user->email_temp && $user->email_temp !== $user->email ) {
            (new VerificationService($user))->sendEmailVerification();
        }
    }
}
