<?php

namespace App\Listeners;

use App\Events\SimpleTokenGenerated;
use App\Notifications\Mail\SimpleTokenNotification;
use Illuminate\Queue\InteractsWithQueue;
use Illuminate\Contracts\Queue\ShouldQueue;

class EmailSendSimpleToken
{
    /**
     * Handle the event.
     *
     * @param  SimpleTokenGenerated  $event
     * @return void
     */
    public function handle(SimpleTokenGenerated $event)
    {
        $user = $event->user;

        (new SimpleTokenNotification())
            ->setTemplateData(['token' => $user->tfa_code])
            ->setRecipient($user->email)
            ->send();
    }
}
