<?php

namespace App\Listeners;

use App\Events\EmployeeAdded;
use App\Services\VerificationService;

class EmailSendActivationLink
{
    /**
     * Handle the event.
     *
     * @param  EmployeeAdded  $event
     * @return void
     */
    public function handle(EmployeeAdded $event)
    {
        (new VerificationService($event->employee))->sendEmailEmployeeRegistration();
    }
}
