<?php

namespace App\Listeners;

use App\Events\EmployeeEdited;
use App\Services\VerificationService;

class EmailResendActivationLink
{
    /**
     * Handle the event.
     *
     * @param  EmployeeEdited  $event
     * @return void
     */
    public function handle(EmployeeEdited $event)
    {
        if ( isset($event->data['email']) && isset($event->oldData['email']) && $event->data['email'] !== $event->oldData['email'] ) {
            (new VerificationService($event->employee))->sendEmailEmployeeRegistration();
        }
    }
}
