<?php

namespace App\Listeners;

use App\Events\CouponRedeemed;

class CouponUsersSendMails
{
    /**
     * Handle the event.
     *
     * @param  CouponRedeemed  $event
     * @return void
     */
    public function handle(CouponRedeemed $event)
    {
        $coupon = $event->coupon;

        $coupon->consumer->sendMail('remind-consumer-when-seller-redeems-coupon', compact('coupon'));
        if ($coupon->consumer->id !== $coupon->agent->id) {
            $coupon->agent->sendMail('remind-agent-when-seller-redeems-coupon', compact('coupon'));
        }
    }
}
