<?php

namespace App\Listeners;


use App\Events\CouponDone;
use App\Transaction;

class CouponReleaseTransactions
{
    /**
     * Handle the event.
     *
     * @param  CouponDone  $event
     * @return void
     */
    public function handle(CouponDone $event)
    {
        $coupon = $event->coupon;

        $transactions = $coupon->transactions()
            ->where('status', Transaction::STATUS_PENDING)
            ->whereIn('type', Transaction::RELEASEABLE)
            ->get();

        foreach ($transactions as $transaction) {
            $transaction->releaseEligible();
        }
    }
}