<?php

namespace App;

use Carbon\Carbon;
use Illuminate\Foundation\Auth\User as Authenticatable;
use Illuminate\Mail\Message;
use Illuminate\Support\Collection;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Log;
use Illuminate\Support\Facades\Mail;
use Illuminate\Support\Facades\View;
use Illuminate\Support\HtmlString;
use Mockery\CountValidator\Exception;
use Spatie\Permission\Models\Role;
use Spatie\Permission\Traits\HasRoles;
use willvincent\Rateable\Rateable;

use App\Library\Billomat\BillomatClientHelper;

class LinkInvitations extends Authenticatable
{
    const REASON_INVITE_NEW_AGENT = 'invite-new-agent';

    protected $fillable = [
        'inviting_user_id',
        'coupon_template_id',
        'shared_account_id',
        'reason',
        'token',
        'is_permanent_link'
    ];

    public function generateInvitationToken()
    {
        $tokens = self::all()->pluck('token');
        $tokens = $tokens->toArray();

        do {
            $token = str_random();
        } while (in_array($token, $tokens));
        return $token;
    }

    /**
     * if no user is given, use currently logged in user
     * @param $reason
     */
    public function generateNewInvitation($reason, $user = null){
        if($user === null){
            $user = Auth::user();
        }
        $invitationData = [
            'inviting_user_id' => $user->id,
            'reason' => $reason,
            'token' => $this->generateInvitationToken(),
        ];

        $this->fill($invitationData);
        $this->save();

        return $this;
    }

    public function invitingUser()
    {
        return $this->belongsTo(User::class);
    }

    public function user()
    {
        return $this->belongsTo(User::class, 'inviting_user_id');
    }

    public function account()
    {
        return $this->belongsTo(Account::class, 'shared_account_id');
    }

    public function couponTemplate()
    {
        return $this->belongsTo(CouponTemplate::class, 'coupon_template_id');
    }
}