<?php

namespace App\Library;

use App\Visit;

class Visits
{
    private $model;
    private $modelId;
    private $modelClass;

    /**
     * Visits constructor.
     * @param $model
     */
    public function __construct($model)
    {
        $this->model      = $model;
        $this->modelId    = $model->id;
        $this->modelClass = class_basename($model);
    }

    /**
     * Method to increment item visits counter if it exists at model.
     */
    public function incrementCounter()
    {
        if ( $this->model->hasVisitsCounter() ) {
            $this->model->visits++;
            $this->model->save();
        }
    }

    /**
     * Method to register visit and increase visits counter if model has it.
     */
    public function register()
    {
        Visit::create([
            'model'    => $this->modelClass,
            'model_id' => $this->modelId,
            'ip'       => request()->ip(),
        ]);

        $this->incrementCounter();
    }
}