<?php

namespace App\Library;

class Utils
{
    /**
     * Method to remove some parameters from GET-query.
     *
     * @param $url
     * @param $params
     * @return string
     */
    public static function removeParamsFromURI($url, $params)
    {
        foreach ($params as $param) {
            $url = preg_replace('/([?&])' . $param . '=[^&]+(&|$)/','$1', $url);
        }

        return trim($url, '?');
    }

    /**
     * Method to add some parameters to GET-query. Existed parameters will be override.
     *
     * @param $url
     * @param $params
     * @return string
     */
    public static function addParamsToURI($url, $params)
    {
        $parts = parse_url($url);

        if ( !isset($parts['query']) ) {
            $parts['query'] = '';
        }

        parse_str($parts['query'], $p);

        foreach ($params as $k => $v) {
            $p[$k] = $v;
        }

        $parts['query'] = http_build_query($p);

        return
            $parts['scheme'] .
            '://' .
            $parts['host'] .
            (isset($parts['path']) ? $parts['path'] : '') .
            '?' .
            $parts['query'];
    }

    /**
     * Method to prepare string to better search.
     *
     * @param $searchString
     * @return mixed
     */
    public static function prepareSearchString($searchString)
    {
        return str_replace([
            ' ', 'ö', 'ä', 'ü', 'ß', ',', '.', ')', '(', '-', '/', "'"
        ], [
            '', 'oe', 'ae', 'ue', 'ss', '', '', '', '', '', '', '',
        ], mb_strtolower($searchString));
    }
}