<?php

namespace App\Library;

use Illuminate\Database\Eloquent\Scope;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Builder;
use Illuminate\Support\Facades\Auth;

class UserStatusScope implements Scope
{


    /**
     * Apply the scope to a given Eloquent query builder.
     *
     * @param  \Illuminate\Database\Eloquent\Builder $builder
     * @param  \Illuminate\Database\Eloquent\Model $model
     * @return void
     */

    static $duringScoping = false;

    public function apply(Builder $builder, Model $model)
    {
        if (self::$duringScoping) {
            return;
        }

        self::$duringScoping = true;
        $user = Auth::user();

        if (!($user && $user->hasRole('operator'))) {
            if($user){
                $builder->where('users.status', \App\User::STATUS_ACTIVE)->orWhere('users.id', $user->id);

            }


        }
        self::$duringScoping = false;
    }
}