<?php

namespace App\Library;

use App\Share;

class Shares
{
    private $model;
    private $modelId;
    private $modelClass;

    /**
     * Shares constructor.
     * @param $model
     */
    public function __construct($model)
    {
        $this->model      = $model;
        $this->modelId    = $model->id;
        $this->modelClass = class_basename($model);
    }

    /**
     * Method to increment item shares counter if it exists at model.
     */
    public function incrementCounter()
    {
        if ( $this->model->hasSharesCounter() ) {
            $this->model->shares++;
            $this->model->save();
        }
    }

    /**
     * Method to register share and increase shares counter if model has it.
     *
     * @param $provider
     */
    public function register($provider)
    {
        Share::create([
            'model'    => $this->modelClass,
            'model_id' => $this->modelId,
            'provider' => $provider,
        ]);

        $this->incrementCounter();
    }
}