<?php

namespace App\Library;


use App\User;

class Options
{
    /**
     * Current user.
     *
     * @var mixed
     */
    private $user;

    /**
     * Options, which might have each user, not only seller.
     *
     * @var array
     */
    private $userOptions = [
        //
    ];

    /**
     * Options constructor.
     * @param User $user
     */
    public function __construct(User $user = null)
    {
        $this->user = $user;
    }

    /**
     * Method to get option value.
     *
     * @param $name
     * @param null $default
     * @return null
     */
    public function get($name, $default = null)
    {
        if ( null === $this->user ) {
            return $default;
        }

        if ( !in_array($name, $this->userOptions) && $this->user->hasRole('employee') ) {
            $this->user = $this->user->boss;
        }

        $option = $this->user->options()
            ->where('key', $name)
            ->first();

        if ( null === $option ) {
            return $default;
        }

        return $option->value;
    }

    /**
     * Method to set option value.
     *
     * @param $name
     * @param $value
     * @return null
     */
    public function set($name, $value)
    {
        if ( null === $this->user ) {
            return null;
        }

        if ( !in_array($name, $this->userOptions) && $this->user->hasRole('employee') ) {
            $this->user = $this->user->boss;
        }

        \App\Options::updateOrCreate([
            'user_id' => $this->user->id,
            'key'     => $name,
        ], [
            'value'   => $value,
        ]);

        return $value;
    }
}