<?php

namespace App\Library\Grids;

use Nayjest\Grids\Components\Base\RenderableRegistry;
use Nayjest\Grids\Components\ColumnHeadersRow;
use Nayjest\Grids\Components\FiltersRow;
use Nayjest\Grids\Components\HtmlTag;
use Nayjest\Grids\Components\Laravel5\Pager;
use Nayjest\Grids\Components\OneCellRow;
use Nayjest\Grids\Components\RecordsPerPage;
use Nayjest\Grids\Components\ShowingRecords;
use Nayjest\Grids\Components\TFoot;
use Nayjest\Grids\Components\THead;

class SimpleGrid extends \Nayjest\Grids\Grid
{
    public function __construct(GridConfig $config)
    {
        $config->setComponents([
            $this->getGridHeader()
        ]);

        $config->setPageSize(0);

        $columns = $config->getColumns();
        foreach($columns as $column) {
            $column->setSortable(false);
        }

        return parent::__construct($config);
    }

    protected function getGridHeader()
    {
        return (new THead)
            ->setComponents([
                (new ColumnHeadersRow)
            ]);
    }
}