<?php


namespace App\Library\Grids;


use Nayjest\Grids\FieldConfig;
use Nayjest\Grids\Filter;
use Nayjest\Grids\FilterConfig;
use Nayjest\Grids\Grid;
use View;

class GlobalFilter extends Filter
{

    var $value = null;

    var $key = 'global';

    public function __construct(FilterConfig $config, FieldConfig $column, Grid $grid, $key = 'global')
    {
        parent::__construct($config, $column, $grid);
        $this->key = $key;
    }

    /**
     * @param null $value
     */
    public function setValue($value)
    {
        $this->value = $value;
    }

    public function getValue()
    {
        if ($this->value) {
            return $this->value;
        }
        return parent::getValue();
    }



    /**
     * Renders filtering control.
     *
     * @return string
     */
    public function render()
    {
        $data = [];
        $data['column'] = $this->getKey();
        $data['filter'] = $this;
        $data['label'] = $this->config->getLabel();
        return View::make(
            $this->getTemplate(),
            $data
        )->render();
    }

    /**
     * @return string
     */
    public function getKey(): string
    {
        return $this->key;
    }

    /**
     * @param string $key
     */
    public function setKey(string $key)
    {
        $this->key = $key;
    }
}