<?php
/**
 * Created by PhpStorm.
 * User: praktikante-pc2
 * Date: 26.09.17
 * Time: 16:58
 */

namespace App\Library;


use App\Exceptions\NotFoundException;
use Equi\Opengeodb\Models\GeodbCoordinate;
use Equi\Opengeodb\Models\GeodbMaster;

class GeoLocation
{
    const MAX_RADIUS=200;
    const RADIUS_STEP=10;


    protected $geoLocation;

    public function __construct($geoLocation)
    {
        $this->geoLocation = $geoLocation;
    }

    public static function getInstanceByString($value)
    {
        if (is_numeric($value)) {
            $base = (new GeodbMaster())->searchByPLZ($value)->first();
        } else {
            $base = (new GeodbMaster())->searchByName($value)->first();
        }

        if ($base == null) {
            throw new NotFoundException('Location for argument not found');
        }

        return new static($base->GeodbCoordinate());
    }

    public function getRadiusQuery($radius)
    {
        return \DB::raw("round(IFNULL((ACOS((SIN(RADIANS(" . $this->geoLocation->lat . "))*SIN(RADIANS(lat)))
                     + (COS(RADIANS(" . $this->geoLocation->lat . "))*COS(RADIANS(lat))*COS(RADIANS(lon)-RADIANS(" . $this->geoLocation->lon . "))))
                     * 6371.110 ),9999),2) <= $radius");
    }

    public function getRadiusValue()
    {

        return "round(IFNULL((ACOS((SIN(RADIANS(" . $this->geoLocation->lat . "))*SIN(RADIANS(lat)))
                     + (COS(RADIANS(" . $this->geoLocation->lat . "))*COS(RADIANS(lat))*COS(RADIANS(lon)-RADIANS(" . $this->geoLocation->lon . "))))
                     * 6371.110 ),9999),2)";
    }
}