<?php

namespace  App\Library;

use App\CouponTemplate;
use Carbon\Carbon;
use Illuminate\Support\HtmlString;

class Format
{

    public function rating($value) {
        return new HtmlString('<input data-size="xs" class="output-rating" value="' . $value .'" class="rating-loading">');
    }

    public function number($value) {
     return number_format($value, 2, ',', '.');
    }

    public function currency($value, $html = true, $hideZero = false) {
        if ($value === null) {
            if ($hideZero) {
                return '';
            } else {
                $value = 0;
            }
        }
        setlocale(LC_MONETARY, "de_DE.UTF-8"); // FIXME: use laravel locale ?!
        $formatted = number_format($value, 2, ',', '.');
        if ($html) {
            return new HtmlString('<nobr><span class="value">' . $formatted . '</span> <span class="unit">€</span></nobr>');
        }
        return $formatted . ' €';
    }

    public function value($value, $html = true) {
        if ($html) {
            return new HtmlString('<span class="value">' . $value . '</span>');
        } else {
            return $value;
        }
    }

    public function percent($value, $html = true) {
        if (round($value) == $value) {
            $formatted = number_format($value, 0, ',', '.');
        } else {
            $formatted = number_format($value, 2, ',', '.');
        }
        if ($html) {
            return new HtmlString('<nobr><span class="value">' . $formatted . '</span> <span class="unit">%</span></nobr>');
        }
        return $formatted  . ' %';
    }

    public function date($value) {
        if ($value == null) {
            return '';
        }
        if (is_string($value)) {
            $value = Carbon::parse($value);
        }
        return $value->format('d.m.Y');
    }

    public function dateTime($value) {
        if ($value == null) {
            return '';
        }
        return $value->format('d.m.Y H:i:s');
    }

    public function recoCode($value)
    {
        return implode(" ", str_split($value, 3));
    }

    public function fee($value, $type = CouponTemplate::TYPE_PERCENT)
    {
        if (CouponTemplate::TYPE_AMOUNT === $type) {
            return $this->currency($value);
        } else {
            return $this->percent($value);
        }
    }
}