<?php

namespace App\Library\Dashboard;
use App\Library\Dashboard\FilterRenderer;
use App\User;
use App\Account;
use Illuminate\Database\Eloquent\Collection;
use Illuminate\Http\Request;


/**
 * @category IMI
 * @package ${MAGENTO_MODULE_NAMESPACE}_${MAGENTO_MODULE}
 */
class Filter
{
    public $selectedPrefix = 'selected';

    /**
     * Explicitly selected
     * @var Collection
     */
    public $selected;

    /**
     * Effectivilty selected (i.e. the same as available if selected is empty filter)
     * @var Collection
     */
    public $actual;

    /**
     * All available selected
     * @var Collection
     */
    public $available;

    protected $subClass;

    protected $class;

    public function __construct($class, $subClass = null, Request $request = null)
    {
        $this->class = $class;
        $this->subClass = ucfirst($subClass);
        if ($request != null) {
            $this->parseRequest($request);
        }
    }

    public function getFieldName()
    {
        $shortName = (new \ReflectionClass($this->class))->getShortName();
        $plural = str_plural($shortName);
        if ($this->subClass) {
            return $this->selectedPrefix . ucfirst($this->subClass) . $plural;
        }
        return $this->selectedPrefix. $plural;
    }

    /**
     * @param Collection $available
     */
    public function setAvailable($available)
    {
        $this->available = $available;
    }

    /**
     * @return Collection
     */
    public function getAvailable()
    {
        if ($this->available == null) {
            $className = $this->class;

            if ($className == User::class) {
                $method = 'all' . str_plural($this->subClass);
                $this->available = $className::$method()->keyBy('id');
            } elseif ($className == Account::class) {
                $method = 'all' . $this->subClass . 'Accounts';
                $this->available = $className::$method()->keyBy('id');
            } else {
                $this->available = $className::all()->keyBy('id');
            }
        }

        return $this->available;
    }

    public function parseRequest(Request $request)
    {
        $className = $this->class;

        $input = $request->input($this->getFieldName(), null);
        if ($input != null) {
            $this->selected = $className::query()->whereIn('id', $input)->get()->keyBy('id');
            $this->selected->intersect($this->getAvailable()); // access protection
            $this->actual = $this->selected;
        } else {
            $this->selected = null;
            $this->actual = $this->getAvailable();
        }
    }

    public function renderSelect($label)
    {
        return FilterRenderer::renderSelect($this, $label);
    }

}