<?php

namespace App\Library\Billomat;

use Storage;
use Phobetor\Billomat\Client\BillomatClient;
use GuzzleHttp\Client;
use GuzzleHttp\Psr7\Request;
use App\Library\Billomat\BillomatDummy;
use \SimpleXMLElement;

class BillomatClientHelper {

    private static $billomatInstance = null;

    /**
     * Loads or Creates Billomatclient
     * 
     * when a billomat client is in cache then load it, else create and store it
     * TODO: use laravel caching, since client is persitent
     */
    public static function getBillomatClientInstance() {

        if ( self::$billomatInstance !== null ) {
            return self::$billomatInstance;
        } else if ( false ) {
            //TODO: Check if in cache and return
        } else {
            //No cached version, create new
            self::$billomatInstance = self::createBillomatClient();
            return self::$billomatInstance;
        }
    }

    public static function createBillomatClient() {
        
        //If no Config for billomat return dummy object
        if ( !config( 'billomat.api.id' ) || !config( 'billomat.api.app.secret' ) ) {
            return new BillomatDummy();
        }

        //Check if app configuration is available, if not create without app access
        if ( config( 'billomat.api.app.id' ) && config( 'billomat.api.app.secret' ) ) {

            return new BillomatClient(
                    config( 'billomat.api.id' ), config( 'billomat.api.key' ), config( 'billomat.api.app.id' ), config( 'billomat.api.app.secret' )
            );
        } else {

            return new BillomatClient(
                    config( 'billomat.api.id' ), config( 'billomat.api.key' )
            );
        }
    }

    public static function storePDF( $disk_driver, $filename, \Guzzle\Http\Message\Response $pdf ) {
        Storage::disk( $disk_driver )->put( $filename, $pdf->getBody(), 'public' );
    }

    /**
     * Method to create an rescurring invoice is missing in phobetor/billomat
     * 
     * @param SimpleXMLElement $xml
     * @return type
     */
    public static function sendAboRequest( $xml ) {

        $client = new Client();
        $api_id = config( 'billomat.api.id' );
        $api_key = config( 'billomat.api.key' );
        $api_app_id = config( 'billomat.api.app.id' );
        $api_app_secret = config( 'billomat.api.app.secret' );


        $headers = [
            'X-BillomatApiKey' => $api_key,
            'Content-Type' => 'application/xml'
        ];

        if ( $api_app_id !== false ) {
            $header['X-AppId'] = $api_app_id;
        }

        if ( $api_app_secret !== false ) {
            $header['X-AppSecret'] = $api_app_secret;
        }

        $request = new Request( 'POST', 'http://' . $api_id . '.billomat.net/api/recurrings', $headers, $xml );

        $response = $client->send( $request );

        $res = $response->getBody()->getContents();

        $xml = new \SimpleXMLElement( $res );
        $id = intval( strip_tags( $xml->id ) );

        return intval( $id );
    }

    public static function array_to_xml( $array, $node_name = "root" ) {
        $dom = new \DOMDocument( '1.0', 'UTF-8' );
        $dom->formatOutput = false;
        $root = $dom->createElement( $node_name );
        $dom->appendChild( $root );

        $array2xml = function ($node, $array) use ($dom, &$array2xml) {
            foreach ( $array as $key => $value ) {
                if ( is_array( $value ) ) {
                    if ( is_numeric( $key ) ) {
                        $array2xml( $n, $value );
                    } else {
                        $n = $dom->createElement( $key );
                        $node->appendChild( $n );
                        $array2xml( $n, $value );
                    }
                } else {
                    $n = $dom->createElement( $key );
                    $n->appendChild( new \DOMText( $value ) );
                    $node->appendChild( $n );
                }
            }
        };

        $array2xml( $root, $array );

        return $dom->saveXML();
    }

	/**
	 * Resolve a article number to ID
	 *
	 * @param $articleNumber Article Number
	 * @return Article ID
	 */
    public static function resolveArticle($articleNumber) {
    	$instance = self::getBillomatClientInstance();
    	$result = $instance->getArticles(['article_number' => $articleNumber]);
    	if (count($result['articles']) == 0 || !isset($result['articles']['article'][0]['id']))  {
    		return null;
	    }
    	return (int) $result['articles']['article'][0]['id'];
    }
}
