<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Mockery\CountValidator\Exception;

class Invitation extends AbstractModel
{
    /**
     * Agent applied to seller as agent
     */
    const AS_AGENT = 'as agent';

    /**
     * Seller asks agent to become an agent for him
     */
    const TO_AGENT = 'to agent';

    const STATUS_PENDING = 'pending';

    const STATUS_REJECTED = 'rejected';

    protected $fillable = [
        'account_id',
        'invited_account_id',
        'status',
        'required_role',
    ];


    public static function findByAccounts(Account $from, Account $to)
    {
        return Invitation::where('account_id', '=', $from->id)->where('Invited_account_id', '=', $to->id)->first();
    }

    public static function invite(Account $from, $role, Account $to)
    {
        $invitation = new Invitation();
        $invitation->account_id = $from->id;
        $invitation->invited_account_id =  $to->id;
        $invitation->required_role = $role;
        $invitation->status = self::STATUS_PENDING;
        $invitation->save();

        return $invitation;
    }

    public function account()
    {
        return $this->belongsTo(Account::class);
    }

    public function invitedAccount()
    {
        return $this->belongsTo(Account::class);
    }

    public function getSeller()
    {
        if ($this->required_role == self::TO_AGENT) {
            return $this->account;
        }
        if ($this->required_role == self::AS_AGENT) {
            return $this->invitedAccount;
        }
        throw new \Exception('Invalid required role');
    }

    public function getAgent()
    {
        if ($this->required_role == self::AS_AGENT) {
            return $this->account;
        }
        if ($this->required_role == self::TO_AGENT) {
            return $this->invitedAccount;
        }
        throw new \Exception('Invalid required role');
    }

    public function reject()
    {
        $this->status = self::STATUS_REJECTED;
        $this->save();
    }

}
