<?php

/*
|--------------------------------------------------------------------------
| Application Routes
|--------------------------------------------------------------------------
|
| Here is where you can register all of the routes for an application.
| It's a breeze. Simply tell Laravel the URIs it should respond to
| and give it the controller to call when that URI is requested.
|
*/

Route::post('/register', 'AuthController@register');

Route::auth();

Route::get('/register/thank-you', ['as' => 'register-thank-you', 'uses' => 'IndexController@thankYou']);


Route::post('/login', 'Auth\AuthController@loginHandler');

Route::get('login/{invitationToken}', ['as' => 'auth.login', 'uses' => 'Auth\AuthController@showLoginForm']);

Route::get('/portraits/{name}', ['as' => 'user-portrait', 'uses' => 'UserController@getImage']);
Route::get('/account/portraits/{name}', ['as' => 'account-portrait', 'uses' => 'ImageController@getImage']);

Route::post('/handleEasyRegistration', ['as' => 'handle-easy-registration', 'uses' => 'Auth\AuthController@handleEasyRegistrationType']);
Route::get('/auth/facebook/callback', 'Auth\AuthController@handleProviderCallback');

Route::get('/share-via-desktop/{token}/{type}', 'CouponTemplateController@shareViaDesktop');
Route::get('/create-link/{reason}/{type}/{id?}', ['as' => 'linkinvitation', 'uses' => 'Controller@link']);
Route::get('/create-link/massinvitation', ['middleware' => ['canAny:recommend recoma'], 'as' => 'massinvitation', 'uses' => 'MassInvitationController@index']);
Route::post('/massinvitation', ['middleware' => ['canAny:recommend recoma'], 'as' => 'massinvitation-post', 'uses' => 'MassInvitationController@create']);
Route::post('/massinvitation/upload', ['middleware' => ['canAny:recommend recoma'], 'as' => 'massinvitation-upload', 'uses' => 'MassInvitationController@upload']);

Route::get('/', ['as' => 'home', 'uses' => 'HomeController@index']);

Route::group(['middleware'=>'onBoardingIncomplete'],function (){

Route::get('/public/profile/{id}', 'UserController@publicProfile');

Route::get('/dashboard/seller', ['middleware' => ['canAny:show seller dashboard'], 'uses' => 'DashboardController@seller']);
Route::post('/dashboard/seller', ['middleware' => ['canAny:show seller dashboard'], 'uses' => 'DashboardController@seller']);
Route::get('/dashboard/agent', ['middleware' => ['canAny:show agent dashboard'], 'uses' => 'DashboardController@agent']);
Route::post('/dashboard/agent', ['middleware' => ['canAny:show agent dashboard'], 'uses' => 'DashboardController@agent']);
Route::get('/dashboard/operator', ['middleware' => ['canAny:show operator dashboard'], 'uses' => 'DashboardController@operator']);
Route::post('/dashboard/operator', ['middleware' => ['canAny:show operator dashboard'], 'uses' => 'DashboardController@operator']);
Route::get('/dashboard/consumer', ['middleware' => ['canAny:show consumer dashboard'], 'uses' => 'DashboardController@consumer']);
Route::post('/dashboard/consumer', ['middleware' => ['canAny:show consumer dashboard'], 'uses' => 'DashboardController@consumer']);




// User & Accounts
Route::model('user', 'App\User');
Route::model('account', 'App\Account');
Route::get('/user', [ 'middleware' => ['canAny:show users,show recruited users'], 'as' => 'user', 'uses' => 'UserController@index']);
Route::get('/user/edit', ['uses' => 'UserController@edit']);
Route::post('/user/edit', ['uses' => 'UserController@store']);
Route::get('/user/edit/{id}', ['as' => 'user-edit-id', 'uses' => 'UserController@edit']);
Route::post('/user/edit/{id}', ['as' => 'user-edit-id-post', 'uses' => 'UserController@store']);
Route::post('/account/edit/{account}', 'UserController@storeAccount');
Route::post('/account/edit/', 'UserController@storeAccount');
Route::post('/user/delete', 'UserController@delete');
Route::get('/user/profile', ['as' => 'user-profile', 'uses' => 'UserController@profile']);
Route::post('/user/profile', 'UserController@postProfile');
Route::post('/user/profile/password', 'UserController@postProfilePassword');
Route::get('/user/mobile/verify', 'UserController@sendVerifyMobileToken');
Route::get('/user/mobile/verify/{verifyMobileToken}', 'UserController@verifyMobile');
Route::get('/account', ['middleware' => ['canAny:edit account'], 'uses' => 'AccountController@index']);
Route::post('/account', ['middleware' => ['canAny:edit account data'], 'uses' => 'AccountController@store']);
Route::get('/user/rating', ['middleware' => ['canAny:show own rating'], 'uses' => 'UserController@rate']);
Route::get('/activate/{id}/{token}', 'Auth\AuthController@verifyEmail');
Route::get('/sellers', ['middleware' => ['canAny:show seller'], 'as' => 'sellers', 'uses'=> 'SellerController@index']);

// User - Fieldservice
Route::get('/user/create-recruited', ['middleware' => ['canAny:create recruited users'], 'as' => 'create-recruited-user', 'uses' => 'UserController@createRecurited']);
Route::post('/user/fieldservice-creates-seller', ['as' => 'fieldservice-creates-seller', 'uses' =>'UserController@storeCreateRecruited']);


// Profiles
// FIXME: add profile/consumer, we might change profile/seller to {account} in stead of user
Route::get('/profile/{role}/{account}', ['as' => 'show-account-generic', 'uses' => 'UserController@showAccount']); //Display profile of choosen agent user
Route::get('/profile/user/{account}', ['as' => 'show-user-account', 'uses' => 'UserController@showAccount']);
Route::get('/profile/agent/{account}', ['as' => 'show-agent-account', 'uses' => 'UserController@showAccount']); //Display profile of choosen agent user
Route::get('/profile/seller/{account}', ['as' => 'show-seller-account', 'uses' => 'UserController@showAccount']); //Display account of seller account
Route::get('/profile/consumer/{account}', ['as' => 'show-consumer-account', 'uses' => 'UserController@showAccount']); //Display account of seller account



//Coupon
Route::model('couponTemplate', 'App\CouponTemplate');
Route::get('/coupon', ['middleware' => ['canAny:show coupon management,show agent coupons'], 'uses' => 'CouponTemplateController@index']);
Route::get('/coupon/seller/{account}', ['as' => 'coupon-templates-by-seller', 'uses' => 'CouponTemplateController@listBySeller']);
Route::get('/coupon/edit', ['middleware' => ['canAny:create coupon template'], 'uses' => 'CouponTemplateController@edit']);
Route::post('/coupon/edit', ['middleware' => ['canAny:create coupon template'], 'uses' => 'CouponTemplateController@store']);
Route::get('/coupon/edit/{couponTemplate}', ['middleware' => ['canAny:create coupon template'], 'as' => 'coupon-id', 'uses' => 'CouponTemplateController@edit']);
Route::post('/coupon/edit/{couponTemplate}', ['middleware' => ['canAny:create coupon template'], 'uses' => 'CouponTemplateController@store']);
Route::get('/coupon/delete/{couponTemplate}', ['middleware' => ['canAny:create coupon template'], 'uses' => 'CouponTemplateController@delete']);
Route::get('/coupon/status/{couponTemplate}/activate', ['middleware' => ['canAny:create coupon template'], 'uses' => 'CouponTemplateController@activate']);
Route::get('/coupon/status/{couponTemplate}/deactivate', ['middleware' => ['canAny:create coupon template'], 'uses' => 'CouponTemplateController@deactivate']);
Route::post('/coupon/redeem', ['middleware' => ['canAny:redeem coupon'], 'as' => 'coupon-redeem', 'uses' => 'CouponController@store']);
Route::get('/coupon/send/{couponTemplate}/{type?}', ['middleware' => ['canAny:show agent coupons'], 'as' => 'coupon-send', 'uses' => 'CouponTemplateController@send']);
Route::post('/coupon/redeemed', ['middleware' => ['canAny:redeem coupon'], 'uses' => 'CouponController@redeemed']);
Route::get('/coupon/get-image/{img}', 'CouponTemplateController@getImage')->name('coupon.get-image');
Route::get('/coupon/get-cashback/{couponTemplate}', 'CouponTemplateController@getCashback')->name('coupon.get-cashback');

Route::get('/redeeming', 'CouponController@redeemingIndex')
    ->middleware('canAny:redeem coupon')
    ->name('coupon.redeeming-index');

Route::get('/coupons/share/{account}/{type?}', ['middleware' => ['canAny:show seller'], 'as' => 'share-coupons-from-seller', 'uses' => 'CouponTemplateController@shareCouponsFromSeller']);
Route::post('/coupons/share/seller', ['middleware' => ['canAny:show seller'], 'as' => 'share-coupons-from-seller-post', 'uses' => 'CouponController@createSelectionCoupons']);

Route::get('/coupons/share/{account}/{type?}', ['middleware' => ['canAny:show seller'], 'as' => 'share-coupons-from-seller', 'uses' => 'CouponTemplateController@shareCouponsFromSeller']);

Route::post('/coupon/store', ['as' => 'share-coupons-template-post', 'uses' => 'CouponController@store']);
Route::get('/coupon/redeem', ['middleware' => ['canAny:redeem coupon,show agent coupons'], 'as' => 'recommended-coupons', 'uses' => 'CouponController@redeem']);
Route::get('/coupon/view/{coupon}', ['as' => 'coupon-view', 'uses' => 'CouponController@viewCoupon']);

Route::get('/agent', ['middleware' => ['canAny:show agents'], 'uses' => 'AgentController@index']);
Route::get('/agent/create', ['middleware' => ['canAny:invite agents'], 'uses' => 'AgentController@create']);
Route::post('/agent/create', ['middleware' => ['canAny:invite agents'], 'uses' => 'AgentController@store']);
Route::get('/agent/register', 'AgentController@registerAgent');

Route::model('seller', 'App\User');
Route::get('/agent/remove/{account}', ['middleware' => ['canAny:show agents'], 'as' => 'agent-account-remove', 'uses' => 'AgentController@remove']);
Route::get('/agent/add/{account}', ['middleware' => ['canAny:show agents'], 'as' => 'agent-account-add', 'uses' => 'AgentController@add']);

Route::get('/seller/remove/{account}', ['middleware' => ['canAny:show seller'], 'as' => 'seller-account-remove', 'uses' => 'AgentController@removeSellerAccount']);
Route::get('/seller/add/{account}', ['middleware' => ['canAny:show seller'], 'as' => 'seller-account-add', 'uses' => 'AgentController@addSellerAccount']);

Route::get('password/set/consumer/{token?}', 'Auth\AuthController@showSetPasswordForConsumerForm');
Route::get('password/set/agent/{token?}', 'Auth\AuthController@showSetPasswordForAgentForm');
Route::get('password/set/seller/{user}/{token?}', 'Auth\AuthController@showSetPasswordForSellerForm');
Route::post('password/set', 'Auth\PasswordController@setUserPassword');

Route::get('operator/reset', ['as' => 'operator-reset', 'uses' => 'Auth\PasswordController@sendResetLinkEmail']);

//Mitarbeiterverwaltung
Route::get('/member', ['middleware' => ['canAny:edit account'], 'uses' => 'AccountController@showMembers']);
Route::post('/member/invite', ['middleware' => ['canAny:edit account data'], 'uses' => 'AccountController@inviteMember']);
Route::get('password/set/member/{token?}', 'Auth\AuthController@showSetPasswordForAgentForm');

// Invitations
Route::model('invitation', 'App\Invitation');
Route::get('/invitation', ['middleware' => ['canAny:show invitation'], 'uses' => 'InvitationController@index']);
Route::get('invitation/accept/{invitation}', ['middleware' => ['canAny:show invitation'], 'uses' => 'InvitationController@accept']);
Route::get('invitation/reject/{invitation}', ['middleware' => ['canAny:show invitation'], 'uses' => 'InvitationController@reject']);

Route::model('coupon', 'App\Coupon');
Route::get('coupon-invitation/accept/{coupon}', 'CouponController@accept');
Route::get('coupon-invitation/reject/{coupon}', 'CouponController@reject');
Route::get('/coupon/paid/{coupon}', ['middleware' => ['canAny:redeem coupon'], 'as' => 'coupon-paid', 'uses' => 'CouponController@paid']);
Route::get('/coupon/assert-payment/{coupon}',
    ['middleware' => ['canAny:show consumer transactions'], 'as' => 'coupon-assert-payment', 'uses' => 'CouponController@assertPayment']
);

Route::get('generatePermanentLinkInvitation', 'Controller@generatePermanentLinkInvitation');


// Job Queue
Route::get('/queue', 'JobController@index');

//Transaction
Route::model('transaction', 'App\Transaction');
Route::get('/transaction', ['middleware' => ['canAny:show operator transactions,show seller transactions,show agent transactions,show consumer transactions'], 'as' => 'transaction', 'uses' => 'TransactionController@index']);
Route::post('/transaction/rate', 'TransactionController@rate');
Route::get('/transaction/sepa_debit', ['middleware' => ['canAny:export sepa files'], 'as' => 'transaction-sepa-debit', 'uses' => 'TransactionController@sepaDebitDownload']);
Route::get('/transaction/sepa_credit', ['middleware' => ['canAny:export sepa files'], 'as' => 'transaction-sepa-credit', 'uses' => 'TransactionController@sepaCreditDownload']);
Route::get('/transaction/request_all_payments', ['as' => 'transaction-request-all-payments', 'uses' => 'TransactionController@requestAllPayments']);
Route::get('/transaction/{name}', 'TransactionController@download');

//Bank Transactions
Route::get('/bank_transaction', ['middleware' => ['canAny:export sepa files'], 'uses' => 'BankTransactionController@index']);

//Invoiceseller
Route::model('invoice', 'App\Invoice');
Route::get('/invoice/pdf/{invoice}', ['middleware' => 'auth', 'as' => 'invoice-downloadpdf', 'uses' => 'InvoiceController@downloadPdf']);

Route::model('creditnote', 'App\CreditNote');
//Credit noteInvoiceController@downloadPdf
Route::get('/creditnote/pdf/{creditnote}', ['middleware' => 'auth', 'as' => 'creditNote-downloadpdf', 'uses' => 'CreditNoteController@downloadPdf']);

Route::get('/imprint', ['as' => 'imprint', 'uses' => 'IndexController@imprint']);

Route::get('/-{code}', ['as' => 'short_link', 'uses' => 'IndexController@shortLink'])->where('code', '[a-z0-9A-Z]+');

Route::get('/contact', 'IndexController@contact');
Route::get('/vorteile',['as' => 'advantages', 'uses' => 'IndexController@advantages']);

Route::get('/faq', 'FaqController@index');

//Recommend RECO.MA
Route::get('/recommend', ['middleware' => ['canAny:recommend recoma'], 'uses' => 'RecommendationController@index']);
Route::post('/recommend/create', 'RecommendationController@recommend');

Route::get('/whatsapp/{reason}', ['middleware' => ['canAny:recommend recoma'], 'uses' => 'Controller@link']);
Route::post('/registration', 'Controller@linkInvitation');
Route::get('/registration/{token}', 'Controller@landingPage');
Route::get('/registration/{token}/landing', 'Controller@preRegister');

Route::get('/registration', 'Auth\AuthController@showUserRegistrationForm')->name('auth.register');
Route::post('/user/register', 'Auth\AuthController@userRegister')->name('user.register');

//routes for buttons from amk for sharing whatsapp,email,sms
Route::get('/recommend-recoma', 'RecommendationController@recommendRecoma')->name('recommendRecoma');
Route::get('/share-seller/{account}', 'RecommendationController@shareSeller')->name('recommendSeller');
Route::get('/share-coupon/{couponTemplate}', 'RecommendationController@shareCoupon')->name('shareCoupon');

Route::get('/seller-invite-new-agent', 'RecommendationController@inviteNewAgent')->name('recommendAgent');


Route::post('/send-mail-invitation-to-user', 'UserController@sendMailToUser');
Route::post('/send-sms-invitation-to-user', 'UserController@sendSMSToUser');

Route::get('/transfer', ['as' => 'transfer', 'uses' => 'CreditNoteController@transfer']);

Route::model('banktransaction', 'App\BankTransaction');
Route::get('/bank_transaction/set/{banktransaction}', ['middleware' => ['canAny:show operator transactions'], 'as' => 'set-bank_transaction-status', 'uses' => 'BankTransactionController@showSetStatus']);
Route::post('/bank_transaction', 'BankTransactionController@setStatus');


//agent Newsletter
Route::model('accountConnection', 'App\AccountConnection');
Route::get('newsletter/accept/{accountConnection}', ['middleware' => ['canAny:show invitation'], 'uses' => 'NewsletterController@accept']);
Route::get('newsletter/reject/{accountConnection}', ['middleware' => ['canAny:show invitation'], 'uses' => 'NewsletterController@reject']);
Route::get('newsletter/acceptConnectionViaEmailButton/{token}', ['as'=> 'acceptConnectionViaEmailButton','uses'=>'NewsletterController@acceptConnectionViaEmailButton']);



});


Route::group(['middleware'=>'canShowOnboardingAgent'],function () {
//Onboarding Agent
    Route::get('/onboarding-agent', ['as' => 'onboarding-agent', 'uses' => 'Onboarding\OnboardingAgentController@index']);
    Route::post('/onboarding-agent-insert-profile-data', ['as' => 'onboarding-agent-insert-profile-data', 'uses' => 'Onboarding\OnboardingAgentController@setProfileData']);
    Route::post('/onboarding-agent-notice-seller', ['as' => 'onboarding-agent-notice-seller', 'uses' => 'Onboarding\OnboardingAgentController@noticeSeller']);
    Route::post('/onboarding-recommend-seller-email', ['as' => 'onboarding-recommend-seller-email', 'uses' => 'UserController@sendMailToUser']);
    Route::post('/onboarding-recommend-seller-sms', ['as' => 'onboarding-recommend-seller-sms', 'uses' => 'UserController@sendSMSToUser']);
});

Route::group(['middleware'=>'canShowOnboardingSeller'],function () {
//Onboarding Seller
    Route::get('/onboarding-seller', ['as' => 'onboarding-seller', 'uses' => 'Onboarding\OnboardingSellerController@index']);
    Route::get('/onboarding-seller-increase-level', ['as' => 'onboarding-seller-increase-level', 'uses' => 'Onboarding\OnboardingSellerController@increaseOnboardingLevel']);
    Route::post('/onboarding-seller-invite-agents', ['as' => 'onboarding-seller-invite-agents', 'uses' => 'Onboarding\OnboardingSellerController@inviteAgents']);
    Route::post('/onboarding-seller-create-coupon', ['as' => 'onboarding-seller-create-coupon', 'uses' => 'CouponTemplateController@store']);
    Route::post('/onboarding-seller-update-profile-company', ['as' => 'onboarding-seller-update-profile-company', 'uses' => 'Onboarding\OnboardingSellerController@updateSellerCompanyOverlay']);
    Route::post('/onboarding-seller-update-payment-company', ['as' => 'onboarding-seller-update-payment-company', 'uses' => 'Onboarding\OnboardingSellerController@updateSellerPaymentOverlay']);
    Route::post('/onboarding-seller-update-accountImg-newsletter', ['as' => 'onboarding-seller-update-accountImg-newsletter', 'uses' => 'Onboarding\OnboardingSellerController@updateDataFromSellerCreatedByAdmOrOperator']);

});

// categories
Route::group(['prefix' => 'categories'], function () {
    Route::get('/', 'CategoryController@index')
        ->middleware('canAny:show categories')
        ->name('category-list');
    Route::get('/create', 'CategoryController@create')
        ->middleware('canAny:create categories')
        ->name('category-create');
    Route::post('/', 'CategoryController@store')
        ->middleware('canAny:create categories')
        ->name('category-store');
    Route::get('/{category}/edit', 'CategoryController@edit')
        ->middleware('canAny:edit categories')
        ->name('category-edit');
    Route::get('/{category}/up', 'CategoryController@up')
        ->middleware('canAny:edit categories')
        ->name('category-up');
    Route::get('/{category}/down', 'CategoryController@down')
        ->middleware('canAny:edit categories')
        ->name('category-down');
    Route::put('/{category}', 'CategoryController@update')
        ->middleware('canAny:edit categories')
        ->name('category-update');
    Route::delete('/{category}', 'CategoryController@destroy')
        ->middleware('canAny:delete categories')
        ->name('category-delete');
});

// widgets (managing and init)
Route::group(['prefix' => 'widgets'], function () {
    Route::get('/', 'WidgetController@index')
        ->middleware('canAny:show widgets')
        ->name('widget-list');
    Route::get('/deals/{alias}', 'WidgetController@deals')
        ->name('widget-deals');
    Route::get('/invite/{alias}', 'WidgetController@invite')
        ->name('widget-invite');
    Route::get('/weru', 'WidgetController@weru')
        ->name('widget-weru');
});

// widgets (embed)
Route::group(['prefix' => 'embed'], function () {
    Route::get('/deals/{alias}', 'WidgetController@dealsEmbed')
        ->name('embed-deals');
    Route::get('/invite/{alias}', 'WidgetController@inviteEmbed')
        ->name('embed-invite');
    // WERU special widget
    Route::get('weru', 'WidgetController@weruEmbed')
        ->name('embed-weru');
});

// helpers
Route::get('/userpic/{user}', 'ImageController@getUserpic')
    ->name('get-userpic');

// api TODO extract to standalone api routes file
Route::group(['prefix' => 'api'], function () {
    Route::group(['middleware' => 'cors'], function () {
        Route::post('login', 'API\UserController@login')
            ->name('api.login');
        Route::post('register', 'API\UserController@register')
            ->name('api.register');
        Route::post('islogged', 'API\UserController@isLogged')
            ->name('api.is-logged');
		Route::post('share_seller/{seller}/email', 'API\InvitationController@shareSeller')
			->name('api.share-seller');
		Route::post('share_seller/{seller}/link', 'API\InvitationController@getShareSellerLink')
			->name('api.share-seller-link');
        Route::post('share_coupon/{couponTemplate}/link', 'API\InvitationController@getShareCouponLink')
            ->name('api.share-coupon-link');
        Route::post('share_coupon/{couponTemplate}/email', 'API\InvitationController@shareCoupon')
            ->name('api.share-coupon');

        Route::post('/coupon/getbycode', 'API\CouponController@getByCode')
            ->name('api.coupon-get-by-code');
        
        Route::group(['middleware' => 'auth'], function () {
            Route::post('/deal/{couponTemplate}/getcashback', 'API\DealController@getCashback')
                ->name('api.get-cashback');
            Route::post('/coupon/{coupon}/rate', 'API\CouponController@rate')
                ->name('api.rate-coupon');
            Route::post('/change_password', 'API\UserController@changePassword')
                ->name('api.change-password');
            Route::post('/change_address', 'API\UserController@changeAddress')
                ->name('api.change-address');
            Route::post('/change_personal', 'API\UserController@changePersonal')
                ->name('api.change-personal');
            Route::post('/change_contacts', 'API\UserController@changeContacts')
                ->name('api.change-contacts');
            Route::post('/change_banking', 'API\UserController@changeBanking')
                ->name('api.change-banking');

            Route::post('/coupon/redeem', 'API\CouponController@redeem')
                ->name('api.redeem-coupon');
        });
    });
});

// gifts
Route::group(['prefix' => 'gifts'], function () {
    Route::get('/', 'GiftController@index')
        ->middleware('canAny:show gifts')
        ->name('gift-list');
    Route::get('/create', 'GiftController@create')
        ->middleware('canAny:create gifts')
        ->name('gift-create');
    Route::post('/', 'GiftController@store')
        ->middleware('canAny:create gifts')
        ->name('gift-store');
    Route::get('/{gift}/edit', 'GiftController@edit')
        ->middleware('canAny:edit gifts')
        ->name('gift-edit');
    Route::put('/{gift}', 'GiftController@update')
        ->middleware('canAny:edit gifts')
        ->name('gift-update');
    Route::delete('/{gift}', 'GiftController@destroy')
        ->middleware('canAny:delete gifts')
        ->name('gift-delete');
    Route::get('/{gift}', 'GiftController@show')
        ->middleware('auth')
        ->name('gift-show');
    Route::get('/{gift}/activate', 'GiftController@activate')
        ->middleware('canAny:edit gifts')
        ->name('gift-activate');
    Route::get('/{gift}/deactivate', 'GiftController@deactivate')
        ->middleware('canAny:edit gifts')
        ->name('gift-deactivate');
});

// users gifts
Route::group(['prefix' => 'usersgifts'], function () {
    Route::get('/', 'UsersGiftController@index')
        ->middleware('canAny:show users gifts')
        ->name('usersgift-list');
    Route::put('/{usersGift}/sent', 'UsersGiftController@markAsSent')
        ->middleware('canAny:edit users gifts')
        ->name('owngift-mark-sent');
});

// own gifts
Route::group(['prefix' => 'my-gifts'], function () {
    Route::get('/', 'UsersGiftController@own')
        ->middleware('canAny:show own gifts')
        ->name('owngift-list');
    Route::get('/{usersGift}/edit', 'UsersGiftController@edit')
        ->name('owngift-edit');
    Route::put('/{usersGift}', 'UsersGiftController@update')
        ->name('owngift-update');
    Route::put('/{usersGift}/received', 'UsersGiftController@markAsReceived')
        ->name('owngift-mark-received');
});

Route::post('/{user}/alias', 'UserController@setAlias')->name('set-alias');

// options
Route::group(['prefix' => 'options'], function () {
    Route::post('/{user}/global', 'OptionsController@saveGlobalWidgetOptions')
        ->name('save-global-widget-options');
    Route::post('/{user}/invite', 'OptionsController@saveInviteWidgetOptions')
        ->name('save-invite-widget-options');
});

Route::get('/weru', function () {
    return view('redesign.weru');
});
Route::get('/weru/deal', function () {
    return view('redesign.weru-deal');
});

Route::get('/derkreis', function () {
    return view('redesign.derkreis');
});
Route::get('/derkreis/deal', function () {
    return view('redesign.derkreis-deal');
});

Route::get('/agb', 'IndexController@agb')->name('agb');
Route::get('/datenschutz', 'IndexController@privacy')->name('privacy');
Route::get('/impressum', 'IndexController@impressum')->name('impressum');
Route::get('/faq', 'IndexController@faq')->name('faq');

Route::get('/seller/{alias}', 'SellerController@showSellerPage')
    ->name('seller.index');
Route::get('/deal/{couponTemplate}', 'CouponTemplateController@deal')
    ->name('deal.index');

Route::group(['middleware' => 'auth'], function () {
    Route::post('fav/{couponTemplate}', 'CouponTemplateController@favoriteToggle')
        ->name('deal.favorite-toggle');
    Route::post('unfav/{couponTemplate}', 'CouponTemplateController@unfavorite')
        ->name('deal.unvaforite');
    Route::get('/profile', 'UserController@userProfile')
        ->name('user.profile');
    Route::get('/fav', 'UserController@favorites')
        ->name('user.fav');
    Route::get('/account', 'UserController@transactions')
        ->name('user.transactions');
    Route::get('/reviews', 'UserController@reviews')
        ->name('user.reviews');
    Route::get('/coupons', 'UserController@coupons')
        ->name('user.coupons');
    Route::post('/user/setname', 'UserController@setName')
        ->name('user.set-name');
    Route::post('/user/setbanking', 'UserController@setBankingData')
        ->name('user.set-banking');
    Route::post('/user/setuserpic', 'UserController@setUserpic')
        ->name('user.set-userpic');
    Route::get('/coupon/{coupon}/view', 'CouponController@getCouponView')
        ->name('coupon.get');
    Route::get('/coupon/{coupon}/print', 'CouponController@print')
        ->name('coupon.print');
});

Route::get('/category/{hierarchy}', 'CategoryController@category')
    ->where('hierarchy','^[a-zA-Z0-9-_\/]+$')
    ->name('category.index')
    ->middleware('openSystem');
Route::any('/search', 'SearchController@index')
    ->name('search')
    ->middleware('openSystem');