<?php

namespace App\Http\Resources;


class MediaResource
{
    private $resource;

    /**
     * MediaResource constructor.
     * @param $resource
     */
    public function __construct($resource)
    {
        $this->resource = $resource;
    }

    /**
     * Method to return resource as array.
     *
     * @return array
     */
    public function toArray()
    {
        return [
            'id'    => $this->resource->id,
            'url'   => asset($this->resource->getUrl()),
            'small' => asset($this->resource->getUrl('small')),
        ];
    }
}