<?php

namespace App\Http\Requests;

use Illuminate\Support\Facades\Auth;

class UsersGiftRequest extends ApiRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        $usersGift = $this->route('usersGift');
        $user = Auth::user();

        return $user->id === $usersGift->user_id && $usersGift->isEditableByOwner();
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {
        return [
            'zip'    => ['required', 'regex:/^([0]{1}[1-9]{1}|[1-9]{1}[0-9]{1})[0-9]{3}$/'],
            'city'   => ['required'],
            'street' => ['required'],
            'house'  => ['required'],
        ];
    }

    /**
     * Get custom attributes for validator errors.
     *
     * @return array
     */
    public function attributes()
    {
        return [
            'zip'    => 'PLZ',
            'city'   => 'Ort',
            'street' => 'Straße',
            'house'  => 'Hausnummer',
        ];
    }
}
