<?php

namespace App\Http\Requests;

use Illuminate\Support\Facades\Auth;

class UsersGiftReceivedRequest extends ApiRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        $usersGift = $this->route('usersGift');
        $user = Auth::user();

        return $user->id === $usersGift->user_id && $usersGift->isSent();
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {
        return [];
    }
}