<?php

namespace App\Http\Requests;

use App\Http\Requests\Request;
use Illuminate\Support\Facades\Auth;

class UserRequest extends Request
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {

        if(Auth::user()->hasRole('operator')){
            $rules = [
                'email' => ['email','max:255'],
                'mobile' => [self::MOBILE_NUMBER,'between:6,30'],
                'phone' => [self::PHONE_OR_FAX_NUMBER,'between:8,16'],
                'fax' => [self::PHONE_OR_FAX_NUMBER,'between:8,16'],
                'iban' => 'iban',
                'iban_owner' => self::IBAN_OWNER,
                'zip' => [self::ZIP,'between:5,5'],
                'housenumber' => self::HOUSENUMBER
            ];
            return  $rules;
        }

        $rules = [
            'salutation' => 'required',
            'firstname' => ['required',self::FIRST_NAME],
            'surname' => ['required',self::SUR_NAME],
            'email' => ['required','email','max:255'],
            'mobile' => [self::MOBILE_NUMBER,'between:6,30'],
            'phone' => [self::PHONE_OR_FAX_NUMBER,'between:8,16'],
            'fax' => [self::PHONE_OR_FAX_NUMBER,'between:8,16'],
            'password' => ['max:255','confirmed']
        ];

        $extendedRules = [
            'street' => ['required',self::STREET],
            'housenumber' => ['required',self::HOUSENUMBER],
            'zip' => ['required',self::ZIP,'between:5,5'],
            'city' => ['required',self::CITY],
            'iban' => ['iban','required'],
            'iban_owner' => ['required',self::IBAN_OWNER]
        ];

        if(Auth::user()->hasRole('seller')){
            $rules['phone']=[self::PHONE_OR_FAX_NUMBER,'between:8,16','required'];
            $rules['company']=[self::COMPANY,'required'];
        }

        if(isset($_POST['iban']) && $_POST['iban'] != '' || isset($_POST['iban_owner']) && $_POST['iban'] != '' || Auth::user()->hasRole('agent')){
                $rules = array_merge($rules, $extendedRules);
                return  $rules;
        }

        if(Auth::user()->can('edit account')) {
            $rules = array_merge($rules, $extendedRules);
            return $rules;
        }
        return $rules;
    }
}
