<?php

namespace App\Http\Requests;

class UserRegisterRequest extends Request
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {
        return [
            'email'    => ['required', 'email', 'unique:users,email'],
            'password' => ['required', 'min:10', 'password_strength:2'],
            'agb'      => ['accepted'],
        ];
    }

    /**
     * Get the error messages for the defined validation rules.
     *
     * @return array
     */
    public function messages()
    {
        return [
            'email.required'             => 'Bitte geben Sie eine gültige E-Mail-Adresse ein.',
            'email.email'                => 'Bitte geben Sie eine gültige E-Mail-Adresse ein.',
            'password.required'          => 'Das Passwort muss ausgefüllt sein.',
            'password.min'               => 'Das Passwort muss mindestens :min Zeichen lang sein.',
            'password.password_strength' => 'Das Passwort ist zu schwach.',
            'agb.accepted'               => 'AGB und Datenschutzerklärung muss akzeptiert werden.',
        ];
    }
}
