<?php

namespace App\Http\Requests;


use App\CouponTemplate;
use Illuminate\Support\Facades\Auth;

class UploadRequest extends ApiRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        $user   = Auth::user();
        $seller = Auth::user();
        $dealId = (int)$this->get('deal_id') ?? 0;

        if ( $user->hasRole('employee') ) {
            $seller = $user->boss;
            return (
                ( $user->canDo('create deals') || $user->canDo('edit deals') ) &&
                $dealId &&
                CouponTemplate::find($dealId) &&
                $seller->id === CouponTemplate::find($dealId)->user_id
            );
        }

        return $dealId && CouponTemplate::find($dealId) && $seller->id === CouponTemplate::find($dealId)->user_id;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {
        return [
            'deal_id' => ['integer', 'exists:coupon_templates,id'],
            'video'   => ['file', 'mimes:mp4', 'max:10000'],
            'image'   => ['file', 'mimes:jpeg,png,gif', 'max:500'],
        ];
    }

    /**
     * Get custom attributes for validator errors.
     *
     * @return array
     */
    public function attributes()
    {
        return [
            'video' => 'Videodatei',
            'image' => 'Bild',
        ];
    }
}