<?php

namespace App\Http\Requests;

class SetPasswordRequest extends Request
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {
        return [
            'password' => ['required', 'min:10', 'password_strength:2', 'confirmed'],
        ];
    }

    /**
     * Get the error messages for the defined validation rules.
     *
     * @return array
     */
    public function messages()
    {
        return [
            'password.required'          => 'Das Passwort muss ausgefüllt sein.',
            'password.min'               => 'Das Passwort muss mindestens :min Zeichen lang sein.',
            'password.password_strength' => 'Das Passwort ist zu schwach.',
        ];
    }
}
