<?php

namespace App\Http\Requests;


class SellerRegistrationRequest extends Request
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }

    /**
     *
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {
        return [
            'firstname' => ['required',self::FIRST_NAME],
            'surname' => ['required',self::SUR_NAME],
            'email' => ['required','unique:users','email','max:255'],
            'password' => ['required','min:6','confirmed'],
            'company' => ['required',self::COMPANY],
            'zip' => ['required',self::ZIP,'between:5,5']
        ];
    }
    public function messages()
    {
        return [
        ];
    }
}
