<?php

namespace App\Http\Requests;

class RegisterShareRequest extends ApiRequest
{
    private $allowedEntities = [
        'deal',
        'seller',
    ];

    private $allowedProviders = [
        'email',
        'facebook',
        'whatsapp',
    ];

    private $tables = [
        'deal'   => 'coupon_templates',
        'seller' => 'users',
    ];

    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {
        $data = $this->validationData();

        $table = isset($this->tables[$data['entity']])
            ? $this->tables[$data['entity']]
            : 'coupon_templates';

        return [
            'entity'   => 'required|in:' . implode(',', $this->allowedEntities),
            'id'       => 'required|integer|exists:' . $table . ',id',
            'provider' => 'required|in:' . implode(',', $this->allowedProviders),
        ];
    }

    /**
     * Get custom attributes for validator errors.
     *
     * @return array
     */
    public function attributes()
    {
        return [
            'id'       => 'ID',
            'entity'   => 'Entität',
            'provider' => 'Provider',
        ];
    }
}
