<?php

namespace App\Http\Requests;


class RateRequest extends ApiRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {
        return [
            'rating' => 'required|min:1|max:5',
            'text'   => 'required',
        ];
    }

    /**
     * Get the error messages for the defined validation rules.
     *
     * @return array
     */
    public function messages()
    {
        return [
            'rating.required' => 'Wählen Sie die Bewertung.',
            'rating.min'      => 'Wählen Sie die Bewertung.',
            'rating.max'      => 'Wählen Sie die Bewertung.',
            'text.required'   => 'Bewertung muss ausgefüllt sein.',
        ];
    }
}