<?php

namespace App\Http\Requests;

use App\Services\GeoService;

class PlaceRequest extends ApiRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {
        $this->sanitize();

        return [
            'zip'         => ['required', 'regex:/^([0]{1}[1-9]{1}|[1-9]{1}[0-9]{1})[0-9]{3}$/'],
            'city'        => ['required'],
            'email'       => ['email'],
            'street'      => ['required'],
            'housenumber' => ['required'],
        ];
    }

    /**
     * Get custom attributes for validator errors.
     *
     * @return array
     */
    public function attributes()
    {
        return [
            'zip'         => 'PLZ',
            'city'        => 'Ort',
            'email'       => 'E-Mail',
            'street'      => 'Straße',
            'housenumber' => 'Hausnummer',
        ];
    }

    /**
     * Method to validate something after rules check.
     *
     * @param $validator
     */
    public function after($validator)
    {
        $data = $this->validationData();
        $addressSet = $data['zip'] && $data['city'] && $data['street'] && $data['housenumber'];

        if ( $addressSet && false === (new GeoService())->getCoordinatesByAddress($data) ) {
            $validator->errors()->add('geo', 'Diese Adresse ist ungültig');
        }
    }

    /**
     * Method to sanitize request.
     */
    public function sanitize()
    {
        $input = array_map('trim', $this->all());
        $this->replace($input);
    }
}
