<?php

namespace App\Http\Requests;


class PayOutRequest extends ApiRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {
        return [
            'items' => ['required', 'array'],
            'type'  => ['required', 'in:bank,paypal'],
        ];
    }

    /**
     * Get custom attributes for validator errors.
     *
     * @return array
     */
    public function attributes()
    {
        return [
            'items' => 'Transaktionen',
            'type'  => 'Auszahlungsmethode',
        ];
    }
}