<?php

namespace App\Http\Requests;

use App\Http\Requests\Request;

class OverlaySellerRequestPayment extends Request
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {
        return [
            'payment' => 'required',
            'iban' => ['required','iban'],
            'iban_owner' => ['required',self::IBAN_OWNER],
            'sepa' => 'required',
            'profile' => ['mimes:jpeg,png,gif','max:256'],
            'data-protection-agb' => 'required',
        ];
    }
}
