<?php

namespace App\Http\Requests;

class OverlaySellerRequestCompany extends Request
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {
        return [
            'phone' => ['required',self::PHONE_OR_FAX_NUMBER,'between:8,16'],
            'zip' => ['required',self::ZIP,'between:5,5'],
            'street' => ['required',self::STREET],
            'housenumber' => ['required',self::HOUSENUMBER],
            'city' => ['required',self::CITY],
            'all_connections' => 'required'
        ];
    }
}
