<?php

namespace App\Http\Requests;

use App\Http\Requests\Request;


class OverlaySellerInviteAgentsRequest extends Request
{

    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {
        /*Wildcard Validation with the JS Validator is broken
            open issue on github: https://github.com/proengsoft/laravel-jsvalidation/issues/297

        */
        return [
            'invitedAgentEmail.*' => ['email','max:255'],
            'invitedAgentEmail.0' => ['email','max:255'],
            'invitedAgentEmail.1' => ['email','max:255'],
            'invitedAgentEmail.2' => ['email','max:255'],
            'invitedAgentEmail.3' => ['email','max:255'],
            'invitedAgentEmail.4' => ['email','max:255']
        ];
    }

    public function messages()
    {
        return [
            'invitedAgentEmail.*' => 'Email-Adresse muss eine gültige Email-Adresse sein'
        ];
    }

}