<?php

namespace App\Http\Requests;



class MassInvitationRequest extends Request
{

    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {
        /*Wildcard Validation with the JS Validator is broken
            open issue on github: https://github.com/proengsoft/laravel-jsvalidation/issues/297
        */
        return [
            'invitedAgent.*' => ['email_or_phone_number','max:255'],
            'invitedAgent.0' => ['email_or_phone_number','max:255', 'required'],
            'invitedAgent.1' => ['email_or_phone_number','max:255'],
            'invitedAgent.2' => ['email_or_phone_number','max:255'],
            'invitedAgent.3' => ['email_or_phone_number','max:255'],
            'invitedAgent.4' => ['email_or_phone_number','max:255']
        ];
    }

    public function messages()
    {
        return [
            'invitedAgentEmail.*' => 'Email-Adresse muss eine gültige Email-Adresse sein'
        ];
    }

}