<?php

namespace App\Http\Requests;


use Illuminate\Support\Facades\Auth;

class MarkCouponAsPaid extends ApiRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        $user   = Auth::user();
        $coupon = $this->route('coupon');

        if ( $user->hasRole('employee') ) {
            $seller = $user->boss;
            return $user->canDo('redeem coupons') && $seller->id === $coupon->template->user_id;
        } else {
            return $user->id === $coupon->template->user_id;
        }
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {
        return [];
    }
}