<?php

namespace App\Http\Requests;

use App\Account;
use App\Http\Requests\Request;
use Illuminate\Support\Facades\Auth;

class LinkRequest extends Request
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {
        return  [
            'zip' => ['required',self::ZIP,'between:5,5'],
            'email' => ['required','unique:users','email','max:255'],
            'password' => ['required','min:6','confirmed'],
        ];
    }
}
