<?php

namespace App\Http\Requests;

use Illuminate\Support\Facades\Auth;

class InviteOptionsRequest extends Request
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {
        $user = Auth::user();

        if ( $user->hasRole('employee') ) {
            $user = $user->boss;
        }

        return [
            'deal' => ['bail', 'required', 'integer', 'min:1', 'exists:coupon_templates,id', 'belongs_to:' . $user->id, 'active_deal'],
        ];
    }

    /**
     * Get custom attributes for validator errors.
     *
     * @return array
     */
    public function attributes()
    {
        return [
            'deal' => 'Deal',
        ];
    }
}
