<?php

namespace App\Http\Requests;

use Illuminate\Support\Facades\Auth;

class GiftRequest extends Request
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        $gift = $this->route('gift');

        return Auth::user()->can($gift ? 'edit gifts' : 'create gifts');
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {
        $gift = $this->route('gift');

        $rules = [
            'name'  => ['required', 'max:250'],
            'price' => ['required', 'numeric', 'min:1'],
        ];

        if (!$gift || null === $gift->image) {
            $rules['image'] = ['required', 'image'];
        }

        return $rules;
    }
}
