<?php

namespace App\Http\Requests;


class FullSellerRegistrationRequest extends Request
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {
        $part1 = new OverlaySellerRequestCompany();
        $part2 = new OverlaySellerRequestPayment();
        $part3 = new SellerRegistrationRequest();
        $rules = array_merge($part1->rules(), $part2->rules(), $part3->rules());
        unset($rules['sepa']);
        unset($rules['password']);
        if(auth()->user()->hasRole('fieldservice_employee')){
            unset($rules['data-protection-agb']);
        }
        return $rules;
    }

    public function messages()
    {
        return [
        ];
    }
}
