<?php

namespace App\Http\Requests;


use App\User;

class EmployeeRequest extends ApiRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {
        if ( isset($this->user) && User::STATUS_PENDING !== $this->user->status ) {
            return [];
        }

        $uniqueRule = isset($this->user)
            ? 'unique:users,email,' . $this->user->id
            : 'unique:users';

        return [
            'email' => [
                'required',
                'email',
                $uniqueRule,
            ],
        ];
    }
}
