<?php

namespace App\Http\Requests;

use App\User;

class EmployeeRegisterRequest extends Request
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        $employee = $this->user;
        $token    = $this->token;

        if ( User::STATUS_PENDING !== $employee->status || !$employee->boss || $token !== $employee->email_verification_token ) {
            return false;
        }

        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {
        return [
            'password' => ['required', 'min:8'],
            'agb'      => ['accepted'],
        ];
    }

    /**
     * Get the error messages for the defined validation rules.
     *
     * @return array
     */
    public function messages()
    {
        return [
            'email.required' => 'Bitte geben Sie eine gültige E-Mail-Adresse ein.',
            'email.email' => 'Bitte geben Sie eine gültige E-Mail-Adresse ein.',
            'password.required' => 'Das Passwort muss ausgefüllt sein.',
            'password.min' => 'Das Passwort muss mindestens 8 Zeichen lang sein.',
            'agb.accepted' => 'AGB und Datenschutzerklärung muss akzeptiert werden.',
        ];
    }
}
