<?php

namespace App\Http\Requests;


use App\User;
use Illuminate\Support\Facades\Auth;

class DetailedActivityRequest extends ApiRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        $user = Auth::user();

        $employeeIDs = $this->request->get('employees', []);

        if ($employeeIDs) {
            $employees = User::whereIn('id', $employeeIDs)->get();
            foreach ($employees as $employee) {
                if ($employee->boss_id !== $user->id) {
                    return false;
                }
            }
        }

        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {
        return [
            'minDate' => 'date',
            'maxDate' => 'date',
        ];
    }
}