<?php

namespace App\Http\Requests;


use Illuminate\Support\Facades\Auth;

class DeleteCoupon extends ApiRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        $coupon = $this->route('coupon');
        $user = Auth::user();

        return $user->id === $coupon->consumer_user_id;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {
        return [];
    }
}