<?php

namespace App\Http\Requests;

use App\Http\Requests\Request;
use Illuminate\Support\Facades\Auth;

class CouponSendRequest extends Request
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return Auth::user()->hasRole(['agent', 'seller']);
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {
        $this->sanitize();

        return [
            'salutation' => 'required',
            'firstname' => ['required',self::FIRST_NAME],
            'surname' => ['required',self::SUR_NAME],
            'email' => ['sometimes','required','email','max:255'],
            'mobile' => ['sometimes','required',self::MOBILE_NUMBER,'between:6,30']
        ];
    }

    /**
     * Method to sanitize request.
     */
    public function sanitize()
    {
        $input = array_map('trim', $this->all());
        $this->replace($input);
    }
}
