<?php

namespace App\Http\Requests;


use Illuminate\Support\Facades\Auth;

class CompanyAddressRequest extends ApiRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        $user = Auth::user();

        return $user->hasRole('employee')
            ? $user->canDo('edit company data', true)
            : true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {
        return [
            'street'      => ['required', 'max:100'],
            'housenumber' => ['required', 'max:20'],
            'zip'         => ['required', 'regex:/^([0]{1}[1-9]{1}|[1-9]{1}[0-9]{1})[0-9]{3}$/'],
            'city'        => ['required', 'max:100'],
            'email'       => ['email'],
        ];
    }

    /**
     * Get custom attributes for validator errors.
     *
     * @return array
     */
    public function attributes()
    {
        return [
            'street'      => 'Straße',
            'housenumber' => 'Hausnummer',
            'zip'         => 'PLZ',
            'city'        => 'Ort',
            'email'       => 'E-Mail',
        ];
    }
}